﻿using System;
using NetOffice;
using NetOffice.Attributes;
namespace NetOffice.OfficeApi.Enums
{
	 /// <summary>
	 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
	 /// </summary>
	 ///<remarks> MSDN Online Documentation: http://msdn.microsoft.com/en-us/en-us/library/office/ff862134.aspx </remarks>
	[SupportByVersion("Office", 9,10,11,12,14,15,16)]
	[EntityType(EntityType.IsEnum)]
	public enum MsoLanguageID
	{
		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>-2</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMixed = -2,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>0</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDNone = 0,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1024</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDNoProofing = 1024,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1078</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDAfrikaans = 1078,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1052</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDAlbanian = 1052,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5121</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicAlgeria = 5121,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>15361</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicBahrain = 15361,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3073</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicEgypt = 3073,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2049</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicIraq = 2049,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11265</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicJordan = 11265,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13313</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicKuwait = 13313,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12289</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicLebanon = 12289,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4097</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicLibya = 4097,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6145</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicMorocco = 6145,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8193</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicOman = 8193,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>16385</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicQatar = 16385,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1025</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabic = 1025,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10241</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicSyria = 10241,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7169</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicTunisia = 7169,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14337</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicUAE = 14337,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9217</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArabicYemen = 9217,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1067</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDArmenian = 1067,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1101</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDAssamese = 1101,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2092</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDAzeriCyrillic = 2092,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1068</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDAzeriLatin = 1068,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1069</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBasque = 1069,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1059</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDByelorussian = 1059,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1093</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBengali = 1093,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1026</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBulgarian = 1026,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1109</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBurmese = 1109,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1027</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDCatalan = 1027,

		 /// <summary>
		 /// SupportByVersion Office 9
		 /// </summary>
		 /// <remarks>3076</remarks>
		 [SupportByVersion("Office", 9)]
		 msoLanguageIDChineseHongKong = 3076,

		 /// <summary>
		 /// SupportByVersion Office 9
		 /// </summary>
		 /// <remarks>5124</remarks>
		 [SupportByVersion("Office", 9)]
		 msoLanguageIDChineseMacao = 5124,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2052</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSimplifiedChinese = 2052,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4100</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDChineseSingapore = 4100,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1028</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTraditionalChinese = 1028,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1050</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDCroatian = 1050,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1029</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDCzech = 1029,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1030</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDDanish = 1030,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2067</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBelgianDutch = 2067,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1043</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDDutch = 1043,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3081</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishAUS = 3081,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10249</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishBelize = 10249,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4105</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishCanadian = 4105,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9225</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishCaribbean = 9225,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6153</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishIreland = 6153,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8201</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishJamaica = 8201,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5129</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishNewZealand = 5129,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13321</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishPhilippines = 13321,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7177</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishSouthAfrica = 7177,

		 /// <summary>
		 /// SupportByVersion Office 9
		 /// </summary>
		 /// <remarks>11273</remarks>
		 [SupportByVersion("Office", 9)]
		 msoLanguageIDEnglishTrinidad = 11273,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2057</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishUK = 2057,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1033</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishUS = 1033,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12297</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEnglishZimbabwe = 12297,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1061</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDEstonian = 1061,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1080</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFaeroese = 1080,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1065</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFarsi = 1065,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1035</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFinnish = 1035,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2060</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBelgianFrench = 2060,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11276</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchCameroon = 11276,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3084</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchCanadian = 3084,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12300</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchCotedIvoire = 12300,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1036</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrench = 1036,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5132</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchLuxembourg = 5132,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13324</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchMali = 13324,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6156</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchMonaco = 6156,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8204</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchReunion = 8204,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10252</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchSenegal = 10252,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4108</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSwissFrench = 4108,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7180</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchWestIndies = 7180,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9228</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrenchZaire = 9228,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1122</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDFrisianNetherlands = 1122,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2108</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGaelicIreland = 2108,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1084</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGaelicScotland = 1084,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1110</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGalician = 1110,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1079</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGeorgian = 1079,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3079</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGermanAustria = 3079,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1031</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGerman = 1031,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5127</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGermanLiechtenstein = 5127,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4103</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGermanLuxembourg = 4103,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2055</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSwissGerman = 2055,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1032</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGreek = 1032,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1095</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDGujarati = 1095,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1037</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDHebrew = 1037,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1081</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDHindi = 1081,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1038</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDHungarian = 1038,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1039</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDIcelandic = 1039,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1057</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDIndonesian = 1057,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1040</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDItalian = 1040,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2064</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSwissItalian = 2064,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1041</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDJapanese = 1041,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1099</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKannada = 1099,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1120</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKashmiri = 1120,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1087</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKazakh = 1087,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1107</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKhmer = 1107,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1088</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKirghiz = 1088,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1111</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKonkani = 1111,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1042</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDKorean = 1042,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1108</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDLao = 1108,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1062</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDLatvian = 1062,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1063</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDLithuanian = 1063,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1071</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMacedonian = 1071,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1086</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMalaysian = 1086,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2110</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMalayBruneiDarussalam = 2110,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1100</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMalayalam = 1100,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1082</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMaltese = 1082,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1112</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDManipuri = 1112,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1102</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMarathi = 1102,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1104</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMongolian = 1104,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1121</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDNepali = 1121,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1044</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDNorwegianBokmol = 1044,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2068</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDNorwegianNynorsk = 2068,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1096</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDOriya = 1096,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1045</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDPolish = 1045,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1046</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDBrazilianPortuguese = 1046,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2070</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDPortuguese = 2070,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1094</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDPunjabi = 1094,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1047</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDRhaetoRomanic = 1047,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2072</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDRomanianMoldova = 2072,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1048</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDRomanian = 1048,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2073</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDRussianMoldova = 2073,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1049</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDRussian = 1049,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1083</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSamiLappish = 1083,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1103</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSanskrit = 1103,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3098</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSerbianCyrillic = 3098,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2074</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSerbianLatin = 2074,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1072</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSesotho = 1072,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1113</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSindhi = 1113,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1051</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSlovak = 1051,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1060</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSlovenian = 1060,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1070</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSorbian = 1070,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11274</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishArgentina = 11274,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>16394</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishBolivia = 16394,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13322</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishChile = 13322,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9226</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishColombia = 9226,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5130</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishCostaRica = 5130,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7178</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishDominicanRepublic = 7178,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12298</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishEcuador = 12298,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>17418</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishElSalvador = 17418,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4106</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishGuatemala = 4106,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>18442</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishHonduras = 18442,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2058</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDMexicanSpanish = 2058,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>19466</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishNicaragua = 19466,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6154</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishPanama = 6154,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>15370</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishParaguay = 15370,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10250</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishPeru = 10250,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>20490</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishPuertoRico = 20490,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3082</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishModernSort = 3082,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1034</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanish = 1034,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14346</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishUruguay = 14346,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8202</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSpanishVenezuela = 8202,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1072</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSutu = 1072,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1089</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSwahili = 1089,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2077</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSwedishFinland = 2077,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1053</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDSwedish = 1053,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1064</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTajik = 1064,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1097</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTamil = 1097,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1092</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTatar = 1092,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1098</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTelugu = 1098,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1054</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDThai = 1054,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1105</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTibetan = 1105,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1073</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTsonga = 1073,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1074</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTswana = 1074,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1055</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTurkish = 1055,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1090</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDTurkmen = 1090,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1058</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDUkrainian = 1058,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1056</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDUrdu = 1056,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2115</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDUzbekCyrillic = 2115,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1091</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDUzbekLatin = 1091,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1075</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDVenda = 1075,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1066</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDVietnamese = 1066,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1106</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDWelsh = 1106,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1076</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDXhosa = 1076,

		 /// <summary>
		 /// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1077</remarks>
		 [SupportByVersion("Office", 9,10,11,12,14,15,16)]
		 msoLanguageIDZulu = 1077,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1118</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDAmharic = 1118,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3076</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDChineseHongKongSAR = 3076,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5124</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDChineseMacaoSAR = 5124,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1116</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDCherokee = 1116,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1125</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDDivehi = 1125,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2129</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDDzongkhaBhutan = 2129,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1126</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDEdo = 1126,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14345</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDEnglishIndonesia = 14345,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11273</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDEnglishTrinidadTobago = 11273,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1124</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDFilipino = 1124,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>15372</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDFrenchHaiti = 15372,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14348</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDFrenchMorocco = 14348,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1127</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDFulfulde = 1127,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1140</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDGuarani = 1140,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1128</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDHausa = 1128,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1141</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDHawaiian = 1141,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1129</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDIbibio = 1129,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1136</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDIgbo = 1136,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1117</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDInuktitut = 1117,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1137</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDKanuri = 1137,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2144</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDKashmiriDevanagari = 2144,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1088</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDKyrgyz = 1088,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1142</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDLatin = 1142,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1138</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDOromo = 1138,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1123</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDPashto = 1123,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2137</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDSindhiPakistan = 2137,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1115</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDSinhalese = 1115,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1143</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDSomali = 1143,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1114</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDSyriac = 1114,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1119</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDTamazight = 1119,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2143</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDTamazightLatin = 2143,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1139</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDTigrignaEthiopic = 1139,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2163</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDTigrignaEritrea = 2163,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1144</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDYi = 1144,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1085</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDYiddish = 1085,

		 /// <summary>
		 /// SupportByVersion Office 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1130</remarks>
		 [SupportByVersion("Office", 10,11,12,14,15,16)]
		 msoLanguageIDYoruba = 1130,

		 /// <summary>
		 /// SupportByVersion Office 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4122</remarks>
		 [SupportByVersion("Office", 11,12,14,15,16)]
		 msoLanguageIDBosnian = 4122,

		 /// <summary>
		 /// SupportByVersion Office 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1153</remarks>
		 [SupportByVersion("Office", 11,12,14,15,16)]
		 msoLanguageIDMaori = 1153,

		 /// <summary>
		 /// SupportByVersion Office 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1131</remarks>
		 [SupportByVersion("Office", 11,12,14,15,16)]
		 msoLanguageIDQuechuaBolivia = 1131,

		 /// <summary>
		 /// SupportByVersion Office 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2155</remarks>
		 [SupportByVersion("Office", 11,12,14,15,16)]
		 msoLanguageIDQuechuaEcuador = 2155,

		 /// <summary>
		 /// SupportByVersion Office 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3179</remarks>
		 [SupportByVersion("Office", 11,12,14,15,16)]
		 msoLanguageIDQuechuaPeru = 3179,

		 /// <summary>
		 /// SupportByVersion Office 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1132</remarks>
		 [SupportByVersion("Office", 11,12,14,15,16)]
		 msoLanguageIDSepedi = 1132,

		 /// <summary>
		 /// SupportByVersion Office 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8218</remarks>
		 [SupportByVersion("Office", 12,14,15,16)]
		 msoLanguageIDBosnianBosniaHerzegovinaCyrillic = 8218,

		 /// <summary>
		 /// SupportByVersion Office 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5146</remarks>
		 [SupportByVersion("Office", 12,14,15,16)]
		 msoLanguageIDBosnianBosniaHerzegovinaLatin = 5146,

		 /// <summary>
		 /// SupportByVersion Office 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9228</remarks>
		 [SupportByVersion("Office", 12,14,15,16)]
		 msoLanguageIDFrenchCongoDRC = 9228,

		 /// <summary>
		 /// SupportByVersion Office 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1071</remarks>
		 [SupportByVersion("Office", 12,14,15,16)]
		 msoLanguageIDMacedonianFYROM = 1071,

		 /// <summary>
		 /// SupportByVersion Office 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7194</remarks>
		 [SupportByVersion("Office", 12,14,15,16)]
		 msoLanguageIDSerbianBosniaHerzegovinaCyrillic = 7194,

		 /// <summary>
		 /// SupportByVersion Office 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6170</remarks>
		 [SupportByVersion("Office", 12,14,15,16)]
		 msoLanguageIDSerbianBosniaHerzegovinaLatin = 6170
	}
}